/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.plan;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceActivityVisitor;
import cz.insophy.inplan.plan.WorkplaceSchedule;

public class WpaDurationVisitor
implements WorkplaceActivityVisitor {
    private final long from;
    private final long to;
    private long bubbleTime = 0L;
    private long offlineTime = 0L;
    private long rebuildTime = 0L;
    private long actionTime = 0L;

    public WpaDurationVisitor(long from, long to) {
        Preconditions.checkState(from < to, "Can only visit positive intervals.");
        this.from = from;
        this.to = to;
    }

    protected long getDurationCut(WorkplaceActivity wa) {
        long duration = wa.getDuration();
        if (wa.getStart() < this.from) {
            duration -= this.from - wa.getStart();
        }
        if (wa.getEnd() > this.to) {
            duration -= wa.getEnd() - this.to;
        }
        return duration;
    }

    @Override
    public void visit(OfflineActivity offline) {
        this.offlineTime += this.getDurationCut(offline);
    }

    @Override
    public void visit(ActionActivity actionActivity) {
        this.actionTime += this.getDurationCut(actionActivity);
    }

    @Override
    public void visit(CumulativeWorkplaceActivity cumActivity) {
        this.actionTime += this.getDurationCut(cumActivity);
    }

    @Override
    public void visit(RebuildActivity rebuildActivity) {
        this.rebuildTime += this.getDurationCut(rebuildActivity);
    }

    @Override
    public void visit(Bubble bubble) {
        if (bubble.isFirst()) {
            bubble.setStart(this.from);
        }
        if (bubble.isLast()) {
            bubble.setEnd(this.to);
        }
        this.bubbleTime += this.getDurationCut(bubble);
    }

    public DurationsSummary getDurationsSummary() {
        return new DurationsSummary(this.bubbleTime, this.offlineTime, this.rebuildTime, this.actionTime);
    }

    public static DurationsSummary calculateDurations(WorkplaceSchedule wps, long from, long to) {
        WpaDurationVisitor visitor = new WpaDurationVisitor(from, to);
        wps.visitActivities(from, to, visitor);
        return visitor.getDurationsSummary();
    }

    public static class DurationsSummary {
        private final long bubbleTime;
        private final long offlineTime;
        private final long rebuildTime;
        private final long actionTime;

        private DurationsSummary(long bubbleTime, long offlineTime, long rebuildTime, long actionTime) {
            this.bubbleTime = bubbleTime;
            this.offlineTime = offlineTime;
            this.rebuildTime = rebuildTime;
            this.actionTime = actionTime;
        }

        public long getBubbleTime() {
            return this.bubbleTime;
        }

        public long getOfflineTime() {
            return this.offlineTime;
        }

        public long getRebuildTime() {
            return this.rebuildTime;
        }

        public long getActionTime() {
            return this.actionTime;
        }
    }
}

